/* this program discribes a filters response */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int filter_id();
double filter( double sample );
void set_defaults();
void alter();
void readfx();

/* define the constants */
#define N 4      /* order + 1 in this case */
double a[4][3];
double b[4][3];
double gain;


int filter_id(){    /* output a line discribing this filter */
static int first_time;

  printf("\n\n     *** 8th order IIR filter ***");  
  printf("\n   consists of 4  2nd order sections\n\n");
  if( ++first_time == 1 ){
     set_defaults();
     }
  return N;
}


double filter( double sample ){

double y;
static double w0[N], w1[N], w2[N];
int i;


for ( i= 0; i < N; i++ ){

 w0[i]= a[i][1]*w1[i] +a[i][2]*w2[i] + a[i][0]*sample;
 y= w0[i] + b[i][1]*w1[i] + b[i][2]*w2[i];
 w2[i]= w1[i];
 w1[i]= w0[i];
 sample= y;               /* output of this section is input of next */
 }

 return y;

}

void set_defaults(){  /* load the default constants */

/* b[n][0] not used */
int i,k;

for( i= 0; i < N; i++ ){
   for( k= 0; k < 3; k++ ) a[i][k]= b[i][k]= 0;
   }

 /* load default for 2 section eliptic low pass */

  a[0][0]= 0.11928;  /* gain */
  a[0][1]= 0.34863;
  a[0][2]= -0.17168;
  b[0][1]= 1.8345;
  b[0][2]= 1.0;
  a[1][0]= 1;
  a[1][1]= -0.12362;
  a[1][2]= -0.71406;
  b[1][1]= 1.26185;
  b[1][2]= 1.0;
  a[2][0]= 1;
  a[3][0]= 1;

  readfx();

}

void alter(){  /* allow altering the filter constants */
char temp[80];  
double val;
int k,i;

for( i= 0; i < N; i++ ){

  for( k= 0; k < 3; k++ ){
     printf("\n a[%d][%d]= %lf ? ",i,k,a[i][k]); 
     val= atof(gets(temp));
     a[i][k]= val ? val : a[i][k];
     if( val == 0 && temp[0] == '0' ) a[i][k]= 0;
     }

  for( k= 1; k < 3; k++ ){
     printf("\n b[%d][%d]= %lf ? ",i,k,b[i][k]); 
     val= atof(gets(temp));
     b[i][k]= val ? val : b[i][k];
     if( val == 0 && temp[0] == '0' ) b[i][k]= 0;
     }
  }
}


void readfx(){   /* read from generated constants file */
int i,j;
double gain2;
FILE  *fp;

  fp= fopen("fx.dat","r");
  if( fp ){
     fscanf(fp,"%d",&i);  /* get number of sections */
     for( j= 0; j < i; ++j ){
        fscanf(fp,"%lf %lf %lf %lf",&a[j][1], &a[j][2], &b[j][1], &b[j][2] );
        }
     fscanf(fp,"%lf",&gain );

     gain= 1.0 / gain;
     gain2= pow ( gain, 1.0 / (double) i );

     for( j= 0; j < i; ++j ){
         a[j][0]= gain2;
         }

     for( ; j < 4; ++j ){
        a[j][0]= 1.0 ;
        a[j][1]= a[j][2]= b[j][1]= b[j][2]= 0;
        }
     }
  fclose( fp );
}
