
/*  
   FR.C    - filter response -  an attempt to simulate a  DSP filter 
*/

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <graphics.h>
#include <conio.h>
#include <string.h>
#include <math.h>


/* functions that are in filter.c */

extern int filter_id();
extern double filter( double sample );
extern void set_defaults();
extern void alter();
extern void readfx();

extern double a[], b[];   /* the filter constants */

/* local function proto's */
void sweep();
int confirm( char *p );
void gen();
double response( double freq, int sample_rate);
void impulse();


#define SWEEP 1
#define ALTER 2
#define DEFAULTS 3
#define AUTOGEN 4
#define IMPULSE 5

int order;

main(){

int command;
int color;

  color= readattr();
  while( 1 ){
     clrscrn2(color);
     order= filter_id();     /* display filter currently linked */
     printf("\n Enter number of desired function\n");
     printf("\n    1 - a sweep of freqencies");
     printf("\n    2 - alter the filter characteristics");
     printf("\n    3 - return to default characteristics");
     printf("\n    4 - generate filter constants");
     printf("\n    5 - save impulse response to a file");
     printf("\n\n -->         ");
     poscurs( cursrow(), 6 ); 
     command= getch() - '0';
     switch ( command ){
        case SWEEP:       sweep(); break;
        case ALTER:       alter();  break;
        case DEFAULTS:    if( confirm("restoring default parameters")){
                              set_defaults();  
                              }
                          break;
        case AUTOGEN:     gen();   break;
        case IMPULSE:     impulse();  break;
        default:          if( command < 0 ){ 
                             if(confirm("program exit")){
                                exit(0);  /* escape or return */
                                }
                             }
                          break;
        }
     }
}


void sweep(){    /* sweep of freqs across a given range */

int low,high,save;    /* band of freq */
int x;
int rate;        /* dsp sample freq */
char temp[80];
double scale=5.0;         

double  max_value;
int step;
double phase= 0;
extern double gain;
FILE *fp;

  printf("\n What is the DSP sample frequency(9600)  ");
  rate= atoi( gets( temp ));
  rate= rate ? rate: 9600;
  printf("\n Enter lowest frequency in sweep(50)  ");
  low= atoi( gets( temp ));
  save= low= low ? low: 50;
  printf("\n Enter highest frequency in sweep(%d)  ",rate/2);
  high= atoi( gets( temp ));
  high= high ? high: rate/2;

  if( setvmode(18) != 18 ){     /* use VGA 640 x 400 16 colors */
     setvmode( DEFAULTMODE );
     printf("\n NEED a VGA card to run this program");
     exit(1);
     }

  sprintf(temp,"Sweep of filter response from %d Hz to %d Hz",low,high);
  move_to( 320 - 4 * strlen( temp ) , 8 );
  plots(temp);

  /* calculate step size */
  step= ( high - low )/ 250;

  /* print a log scale on side */
  for( x= 20; x >= -60 ; x-= 20 ){
     move_to( 0, 150 - (int)scale*x );
     sprintf(temp,"%+ddb",x);
     plots(temp);
     }
  
/* plot the calculated response */
  if( low == 50 && high == rate/2 ){
     fp= fopen( "fm.dat","r" );
     if( fp ){
        x= 35;
        for( ; low < high ; low += step ){
           if( ((x-35) % 100 ) == 0){
              move_to( x, 162 );
              plots("|");
              sprintf(temp,"%d",low);
              move_to( x-8, 176 );
              plots(temp);
              }

           fscanf(fp,"%*lf %lf",&max_value);
           max_value= max_value * gain;

           if( max_value > 0 ){
              setpixel( x, 150 );
              pen_color(10);
              setpixel( x++, (int)(150 - scale*20*log10(max_value)) ); 
              setpixel( x, (int)(150 - scale*20*log10(max_value)) );
              pen_color(15);
              setpixel( x++, 150 );

              }

           if( kbhit() ) break;
           }
        fclose(fp);
        }
     }


 /* plot simulation */
  low= save;
  x= 35;
  for( ; low < high ; low += step ){
     if( ((x-35) % 100 ) == 0){
        move_to( x, 162 );
        plots("|");
        sprintf(temp,"%d",low);
        move_to( x-8, 176 );
        plots(temp);
        }

     max_value= response( low, rate );

     if( max_value > 0 ){
        setpixel( x, 150 );
        pen_color(14);
        setpixel( x++, (int)(150 - scale*20*log10(max_value)) ); 
        setpixel( x, (int)(150 - scale*20*log10(max_value)) );
        pen_color(15);
        setpixel( x++, 150 );

        }

     if( kbhit() ) break;
     }


  /* at end of graphics presentation */
  move_to( 250, 440 );
  plots("Hit a key to cont...");
  getch();  /* pause */
  setvmode( DEFAULTMODE );
}

int confirm( char *p ){
int c;

   printf("\n    TYPE 'y' to confirm %s",p);
   c= getch();
   if( c == 'y' || c == 'Y' ) return 1;
   return 0;
}


struct freq{
   double val;        /* freq value */
   double highval;    /* limits  in db*/
   double lowval;
   double lastval;    /* where it was db */
   double thisval;    /* current trial value */
   };


void gen(){         /* generate filter constants based upon user spec's */

   system("p8");
   readfx();

}


  /* calculate the filter response */
double response( double freq, int sample_rate ){

double spu;
double max_value, sample; 
static double phase, old_freq;
int i;


     spu= 6.2832 * freq / sample_rate;  /* compute signal phase update in radians */
  /* avoid discontinuity in freqs sent to filter */
     max_value= freq - old_freq;
     if( max_value < 0 ) max_value= -max_value;
     if( max_value > 50 ){
        for( i= 0; i < 50; i++){  
           filter( sin(phase));
           phase += spu;
           }
        }
     old_freq= freq;
     max_value= 0;
     for( i= 0; i < (long)(sample_rate/freq) + 30 ; i++){
        sample= filter(sin(phase)); 
        if( sample > max_value ) max_value= sample;
        phase+= spu;
        }
    return max_value;
}

void impulse(){
int i;
FILE *fp;
double imp;

    /* attempt to clear the delay terms */

    printf("Writing to impulse.tmp...");
    for( i= 0; i < 1000; ++i ) filter( (double)0 );

    /* just write them out to temp file for now */
    fp= fopen("impulse.tmp","w");
    if( fp == 0 ) return;


    for( i= 0; i < 80; ++i ){     /* gen impulse data */
       if( i == 0 ) imp= filter( (double) 1 );
       else imp= filter( (double) 0 );
       fprintf(fp,"%lf\n",imp);
       }
    fclose( fp );

       
}

