/* p8.f -- translated by f2c (version 19940714).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"
#include <stdio.h>
#include <math.h>

/* Common Block Declarations */

struct {
    real r1, r2, wp, ws;
    integer n2, n;
    real sr;
    integer ka, kad, kod, kf;
} parm_;

#define parm_1 parm_

struct {
    real pr[20], pi[20], zr[20], zi[20];
} root_;

#define root_1 root_

struct {
    real sn, cn, dn;
} elp1_;

#define elp1_1 elp1_

/* Table of constant values */

static integer c__9 = 9;
static integer c__1 = 1;
static integer c__3 = 3;
static integer c__4 = 4;
static doublereal c_b100 = 10.;
static doublereal c_b114 = 2.;
static complex c_b125 = {(float)1.,(float)0.};

/*       THIS IS A IIR FILTER DESIGN PROGRAM */
/*       FOR BUTTERWORTH, CHEBYSHEV, CHEBYSHEV II, & ELLIPTIC */
/*       FOR LOWPASS, HIGHPASS, BANDPASS, AND BANDREJECT RESPONSES */
/*       ANALOG AND DIGITAL FILTERS USING THE BLT */
/*          PASS AND STOPBAND EDGES ARE IN HERTZ FOR A SAMPLING */
/*          RATE OF 1. MAXIMUM PASSBAND RIPPLE AND MINIMUM */
/*          STOPBAND ATTENUATION ARE IN POSITIVE DB. */
/*       C. S. BURRUS,    RICE UNIVERSITY,    JAN 25, 1986 */
/* ------------------------------------------------------------------ */
/* Main program */ 
main()
{
    /* System generated locals */
    real r__1;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    extern /* Subroutine */ int view_(), prnt_();
    static real g, a1[20], b1[20], b2[20], a2[20], f1, f2, f3, f4, w0, w1, w2,
	     w3, w4, db;
    extern /* Subroutine */ int cascad_();
    static real fm[530];
    static integer kk;
    static real fp;
    extern /* Subroutine */ int roots1_();
    static real fs;
    extern /* Subroutine */ int roots2_();
    static real tp;
    extern doublereal prewrp_();
    extern /* Subroutine */ int afr_(), dfr_(), blt_();
    static real wst;
    extern /* Subroutine */ int freqxfm_();


/* ---------INPUT SPECIFICATIONS, PREWARPING, AND PREFREQXFRMING------- */
/*    
    printf("\nENTER NUMBER OF FREQS TO DISPLAY ");
    scanf("%d",&kk);
*/
	kk= 251;

L10:
    printf("ENTER 1 FOR BW, 2 FOR CHEBY ,3 FOR ICHEBY, 4 FOR ELL ");
    scanf("%d",&parm_1.ka);
    printf("ENTER 1 FOR LOWPASS, 2 FOR HP, 3 FOR BP, OR 4 FOR BR ");
    scanf("%d",&parm_1.kf);
 /*   printf("ENTER 1 FOR ANALOG, 2 FOR DIGITAL ");
    scanf("%d",&parm_1.kad );
 */     parm_1.kad= 2;  /* no analog code anyway ? */

    tp = (float)6.283185307179586;
    if (parm_1.kad == 1) {
	goto L12;
    }
    printf("ENTER SAMPLE RATE ");
    scanf("%f",&parm_1.sr );

L12:
    if (parm_1.ka == 4) {
	goto L20;
    }
    printf("ENTER THE ORDER ");
    scanf("%d",&parm_1.n );
    if (parm_1.kf >= 3) {
	goto L15;
    }
    printf("ENTER THE BAND EDGE IN UN-NORMALIZED HZ ");
    scanf("%f", &fp );
    r__1 = tp * fp;
    parm_1.wp = prewrp_(&r__1);
    if (parm_1.kf == 2) {
	parm_1.wp = (float)1. / parm_1.wp;
    }
    if (parm_1.ka == 1) {
	goto L30;
    }
    printf("ENTER PASSBAND RIPPLE OR STOPBAND ATT IN POSITIVE DB ");
    scanf("%f", &parm_1.r1 );
    if (parm_1.ka == 3) {
	parm_1.ws = parm_1.wp;
    }
    goto L30;
L15:
    printf("ENTER THE LOWER & UPPER BAND EDGES IN HERTZ " );
    scanf("%f%f", &f1,  &f2 );
    r__1 = tp * f1;
    w1 = prewrp_(&r__1);
    r__1 = tp * f2;
    w2 = prewrp_(&r__1);
    w0 = sqrt(w1 * w2);
    parm_1.wp = (w2 * w2 - w0 * w0) / w2;
    if (parm_1.kf == 4) {
	parm_1.wp = 1 / parm_1.wp;
    }
    if (parm_1.ka == 1) {
	goto L30;
    }
    printf("ENTER PASSBAND RIPPLE OR STOPBAND ATT IN + DB ");
    scanf("%f", &parm_1.r1 );
    if (parm_1.ka == 3) {
	parm_1.ws = parm_1.wp;
    }
    goto L30;
L20:
    if (parm_1.kf >= 3) {
	goto L25;
    }
    printf("ENTER PASS AND STOPBAND EDGES IN UN-NORMALIZED HZ "); 
    scanf("%f", &fp );
    scanf("%f", &fs );
    r__1 = tp * fp;
    parm_1.wp = prewrp_(&r__1);
    r__1 = tp * fs;
    parm_1.ws = prewrp_(&r__1);
    if (parm_1.kf == 2) {
	parm_1.wp = (float)1. / parm_1.wp;
    }
    if (parm_1.kf == 2) {
	parm_1.ws = (float)1. / parm_1.ws;
    }
    printf("ENTER PASSBAND RIPPLE AND STOPBAND ATTENUATION IN +DB ");
    scanf("%f%f", &parm_1.r1, &parm_1.r2 );
    goto L35;
L25:
    printf("ENTER F1,F2,F3,F4 FOR BP OR BR FREQS ");
    scanf("%f%f%f%f", &f1, &f2, &f3, &f4 );
    r__1 = tp * f1;
    w1 = prewrp_(&r__1);
    r__1 = tp * f2;
    w2 = prewrp_(&r__1);
    r__1 = tp * f3;
    w3 = prewrp_(&r__1);
    r__1 = tp * f4;
    w4 = prewrp_(&r__1);
    w0 = sqrt(w3 * w2);
    parm_1.wp = (w3 * w3 - w0 * w0) / w3;
    parm_1.ws = (w4 * w4 - w0 * w0) / w4;
    wst = (w0 * w0 - w1 * w1) / w1;
    if (wst < parm_1.ws) {
	parm_1.ws = wst;
    }
    if (parm_1.kf == 3) {
	goto L26;
    }
    w0 = sqrt(w1 * w4);
    parm_1.wp = w1 / (w0 * w0 - w1 * w1);
    parm_1.ws = w2 / (w0 * w0 - w2 * w2);
    wst = w3 / (w3 * w3 - w0 * w0);
    if (wst < parm_1.ws) {
	parm_1.ws = wst;
    }
L26:
    printf("ENTER PASSBAND RIPPLE AND STOPBAND ATTENUATION IN + DB ");
    scanf("%f%f", &parm_1.r1, &parm_1.r2 );
    goto L35;
/* -------------BUTTERWORTH, CHEBYSHEV, AND ELLIPTIC FILTERS-- */
L30:
    roots1_();
    goto L37;
L35:
    roots2_();
/* ---------HIGHPASS, BANDPASS, AND BAND REJECT XFORMS-------- */
L37:
    if (parm_1.kf == 1) {
	goto L65;
    }
    freqxfm_(&w0, root_1.pr, root_1.pi);
    freqxfm_(&w0, root_1.zr, root_1.zi);
    if (parm_1.kf == 2) {
	goto L65;
    }
    parm_1.n2 = parm_1.n;
    parm_1.n <<= 1;
    parm_1.kod = 0;
L65:
    if (parm_1.kad == 1) {
	goto L80;
    }
/* -------------DIGITAL BILINEAR XFORM------------------------ */
    blt_(&parm_1.n2, &parm_1.sr, root_1.pr, root_1.pi);
    blt_(&parm_1.n2, &parm_1.sr, root_1.zr, root_1.zi);
    printf("Z PLANE\n");
    prnt_(&parm_1.n2, root_1.pr, root_1.pi, root_1.zr, root_1.zi);
/* -------------CASCADE STRUCTURE AND FREQUENCY RESPONSE------ */
L80:
    cascad_(root_1.pr, root_1.pi, root_1.zr, root_1.zi, b1, b2, a1, a2, &g);
    if (parm_1.kad == 2) {
	dfr_(&kk, b1, b2, a1, a2, fm, &g);
    }
    if (parm_1.kad == 1) {
	afr_();
    }
    view_(&kk, fm, &db);
 
 /*   goto L10;  */

} /* MAIN__ */

/* -------------END OF MAIN PROGRAM------------------------- */
/* -------------BW, CHEBY I&II POLE & ZERO LOCATIONS-------- */
/* Subroutine */ int roots1_()
{
    /* System generated locals */
    integer i__1;
    real r__1;
    doublereal d__1;

    /* Builtin functions */
    double pow_dd(), sqrt(), log(), sinh(), cosh(), cos(), sin();

    /* Local variables */
    static real e;
    static integer j, l;
    static real v0, cm, ti, sm, tr, arg;


    d__1 = (doublereal) (parm_1.r1 * (float).1);
    e = sqrt(pow_dd(&c_b100, &d__1) - 1);
    if (parm_1.ka == 3) {
	e = 1 / e;
    }
    l = 0;
    parm_1.n2 = (parm_1.n + 1) / 2;
    parm_1.kod = 1;
    if (parm_1.n % 2 == 0) {
	parm_1.kod = 0;
    }
    if (parm_1.kod == 0) {
	l = 1;
    }
    sm = (float)1.;
    cm = (float)1.;
    if (parm_1.ka == 1) {
	goto L10;
    }
    r__1 = 1 / e;
    v0 = log(r__1 + sqrt(r__1 * r__1 + 1)) / parm_1.n;
    sm = sinh(v0);
    cm = cosh(v0);
L10:
    i__1 = parm_1.n2;
    for (j = 1; j <= i__1; ++j) {
	arg = l * (float)1.570796326794897 / parm_1.n;
	tr = -(doublereal)sm * cos(arg);
	ti = cm * sin(arg);
	root_1.zr[j - 1] = (float)0.;
	root_1.zi[j - 1] = (float)1e25;
	if (parm_1.ka == 3) {
	    goto L11;
	}
	root_1.pr[j - 1] = parm_1.wp * tr;
	root_1.pi[j - 1] = parm_1.wp * ti;
	goto L12;
L11:
	if (l != 0) {
	    root_1.zi[j - 1] = parm_1.ws / sin(arg);
	}
	root_1.pr[j - 1] = parm_1.ws * tr / (tr * tr + ti * ti);
	root_1.pi[j - 1] = parm_1.ws * ti / (tr * tr + ti * ti);
L12:
	l += 2;
/* L15: */
    }
    return 0;
} /* roots1_ */

/* -----------ELLIPTIC FILTER POLE & ZERO LOCATIONS------ */
/* Subroutine */ int roots2_()
{
    /* System generated locals */
    integer i__1;
    real r__1;
    doublereal d__1;

    /* Builtin functions */
    double pow_dd(), sqrt();

    /* Local variables */
    static real e;
    static integer j;
    static real k;
    static integer l;
    extern doublereal arcsc_();
    static real k1, v0, kc, cm;
    extern doublereal fk_();
    static real dm, kk, sm, xn, k1c, kk1;
    extern doublereal cei_();
    static real kkc, arg;
    extern /* Subroutine */ int elp_();
    static real kk1c;


    d__1 = (doublereal) (parm_1.r1 * (float).1);
    e = sqrt(pow_dd(&c_b100, &d__1) - 1);
    k = parm_1.wp / parm_1.ws;
    kc = sqrt(1 - k * k);
    d__1 = (doublereal) (parm_1.r2 * (float).1);
    k1 = e / sqrt(pow_dd(&c_b100, &d__1) - 1);
    k1c = sqrt(1 - k1 * k1);
    kk = cei_(&kc);
    kkc = cei_(&k);
    kk1 = cei_(&k1c);
    kk1c = cei_(&k1);
    xn = kk * kk1c / kk1 / kkc;
    parm_1.n = (integer) (xn + (float)1.);
    printf("N= " );
    scanf("%d", &parm_1.n );
    r__1 = parm_1.n * kkc / kk;
    k1 = fk_(&r__1);
    k1c = sqrt(1 - k1 * k1);
    kk1 = cei_(&k1c);
    l = 0;
    parm_1.n2 = (parm_1.n + 1) / 2;
    parm_1.kod = 1;
    if (parm_1.n % 2 == 0) {
	parm_1.kod = 0;
    }
    if (parm_1.kod == 0) {
	l = 1;
    }
    r__1 = 1 / e;
    v0 = kk / kk1 / parm_1.n * arcsc_(&r__1, &k1);
    elp_(&v0, &k);
    sm = elp1_1.sn;
    cm = elp1_1.cn;
    dm = elp1_1.dn;
    root_1.zi[0] = (float)1e25;
    i__1 = parm_1.n2;
    for (j = 1; j <= i__1; ++j) {
	arg = kk * l / parm_1.n;
	elp_(&arg, &kc);
	root_1.zr[j - 1] = (float)0.;
	if (l != 0) {
	    root_1.zi[j - 1] = parm_1.ws / elp1_1.sn;
	}
	d__1 = (doublereal) (elp1_1.dn * sm);
	root_1.pr[j - 1] = -(doublereal)parm_1.wp * sm * cm * elp1_1.cn * 
		elp1_1.dn / (1 - pow_dd(&d__1, &c_b114));
	d__1 = (doublereal) (elp1_1.dn * sm);
	root_1.pi[j - 1] = parm_1.wp * dm * elp1_1.sn / (1 - pow_dd(&d__1, &
		c_b114));
	l += 2;
/* L15: */
    }
    return 0;
} /* roots2_ */

/* ----------PREWARP OF FREQS BEFORE BLT-------------------- */
doublereal prewrp_(ww)
real *ww;
{
    /* System generated locals */
    real ret_val;

    /* Builtin functions */
    double tan();

    if (parm_1.kad == 1) {
	ret_val = *ww;
    }
    if (parm_1.kad != 1) {
	ret_val = parm_1.sr * (float)2. * tan(*ww / (float)2. / parm_1.sr);
    }
    return ret_val;
} /* prewrp_ */

/* ----------DIGITAL BILINEAR TRANSFORMATION---------------- */
/* Subroutine */ int blt_(n2, sr, r, i)
integer *n2;
real *sr, *r, *i;
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Local variables */
    static real a;
    static integer j;
    static real td, ti, tr;


    /* Parameter adjustments */
    --i;
    --r;

    /* Function Body */
    a = *sr * (float)2.;
    i__1 = *n2 + 1;
    for (j = 1; j <= i__1; ++j) {
	tr = r[j];
	ti = i[j];
	if (fabs(ti) > (float)1e15) {
	    goto L10;
	}
	if (fabs(tr) > (float)1e15) {
	    goto L10;
	}
/* Computing 2nd power */
	r__1 = a - tr;
	td = r__1 * r__1 + ti * ti;
	r[j] = (a * a - tr * tr - ti * ti) / td;
	i[j] = a * (float)2. * ti / td;
	goto L15;
L10:
	r[j] = (float)-1.;
	i[j] = (float)0.;
L15:
	;
    }
    return 0;
} /* blt_ */

/* -------------FREQUENCY TRANSFORMATION-------------------- */
/* Subroutine */ int freqxfm_(w0, pr, pi)
real *w0, *pr, *pi;
{
    /* System generated locals */
    integer i__1, i__2, i__3;
    real r__1;
    doublereal d__1;
    complex q__1, q__2, q__3, q__4, q__5;

    /* Builtin functions */
    void c_div();
    double r_imag();
    void c_sqrt();

    /* Local variables */
    static integer j;
    static complex pc, sc;
    static integer nt;


    /* Parameter adjustments */
    --pi;
    --pr;

    /* Function Body */
    nt = (parm_1.n2 << 1) + 1;
    if (parm_1.kf >= 3) {
	goto L12;
    }
/* L5: */
    i__1 = parm_1.n2;
    for (j = 1; j <= i__1; ++j) {
	if (pi[j] > (float)1e15) {
	    goto L7;
	}
	i__2 = j;
	i__3 = j;
	q__1.r = pr[i__2], q__1.i = pi[i__3];
	pc.r = q__1.r, pc.i = q__1.i;
	c_div(&q__1, &c_b125, &pc);
	sc.r = q__1.r, sc.i = q__1.i;
	pr[j] = -(doublereal)(r__1 = sc.r, fabs(r__1));
	pi[j] = (r__1 = r_imag(&sc), fabs(r__1));
	goto L10;
L7:
	pr[j] = (float)0.;
	pi[j] = (float)0.;
L10:
	;
    }
    return 0;
L12:
    i__1 = parm_1.n2;
    for (j = 1; j <= i__1; ++j) {
	if (pi[j] > (float)1e15) {
	    goto L13;
	}
	i__2 = j;
	i__3 = j;
	q__1.r = pr[i__2], q__1.i = pi[i__3];
	pc.r = q__1.r, pc.i = q__1.i;
	if (parm_1.kf == 4) {
	    c_div(&q__1, &c_b125, &pc);
	    pc.r = q__1.r, pc.i = q__1.i;
	}
	q__5.r = pc.r * pc.r - pc.i * pc.i, q__5.i = pc.r * pc.i + pc.i * 
		pc.r;
	d__1 = *w0 * 4 * *w0;
	q__4.r = q__5.r - d__1, q__4.i = q__5.i;
	c_sqrt(&q__3, &q__4);
	q__2.r = pc.r - q__3.r, q__2.i = pc.i - q__3.i;
	q__1.r = q__2.r / (float)2., q__1.i = q__2.i / (float)2.;
	sc.r = q__1.r, sc.i = q__1.i;
	pr[j] = -(doublereal)(r__1 = sc.r, fabs(r__1));
	pi[j] = (r__1 = r_imag(&sc), fabs(r__1));
	q__5.r = pc.r * pc.r - pc.i * pc.i, q__5.i = pc.r * pc.i + pc.i * 
		pc.r;
	d__1 = *w0 * 4 * *w0;
	q__4.r = q__5.r - d__1, q__4.i = q__5.i;
	c_sqrt(&q__3, &q__4);
	q__2.r = pc.r + q__3.r, q__2.i = pc.i + q__3.i;
	q__1.r = q__2.r / (float)2., q__1.i = q__2.i / (float)2.;
	sc.r = q__1.r, sc.i = q__1.i;
	pr[nt - j] = -(doublereal)(r__1 = sc.r, fabs(r__1));
	pi[nt - j] = (r__1 = r_imag(&sc), fabs(r__1));
	goto L14;
L13:
	pr[j] = (float)0.;
	pr[nt - j] = (float)0.;
	pi[j] = (float)1e17;
	pi[nt - j] = (float)0.;
	if (parm_1.kf == 4) {
	    pi[j] = *w0;
	}
	if (parm_1.kf == 4) {
	    pi[nt - j] = *w0;
	}
L14:
	;
    }
    return 0;
} /* freqxfm_ */

/* -----------COMPLETE ELLIPTIC INTEGRAL--------------- */
doublereal cei_(kc)
real *kc;
{
    /* System generated locals */
    real ret_val;

    /* Builtin functions */
    double sqrt();

    /* Local variables */
    static real a, b;
    static integer j;
    static real at;

    a = (float)1.;
    b = *kc;
    for (j = 1; j <= 20; ++j) {
	at = (a + b) / 2;
	b = sqrt(a * b);
	a = at;
	if ((a - b) / a < (float)1.2e-7) {
	    goto L15;
	}
/* L10: */
    }
    printf("\nCEI FAILED TO CONVERGE\n");
L15:
    ret_val = (float)1.570796326794896 / a;
    return ret_val;
} /* cei_ */

/* -------------ELLIPTIC FUNCTIONS------------------ */
/* Subroutine */ int elp_(x, kc)
real *x, *kc;
{
    /* Builtin functions */
    double sqrt();
    double tan();

    /* Local variables */
    static real a, b, c, d, e;
    static integer i;
    static real aa[16], bb[16], at;

    if (*x == (float)0.) {
	goto L20;
    }
    i = 1;
    a = (float)1.;
    b = *kc;
L4:
    aa[i - 1] = a;
    bb[i - 1] = b;
    at = (a + b) / 2;
    b = sqrt(a * b);
    a = at;
    if ((a - b) / a < (float)1.3e-7) {
	goto L15;
    }
    if (i > 15) {
	goto L10;
    }
    ++i;
    goto L4;
L10:
    printf("\nELP FAILED TO CONVERGE\n");
L15:
    c = a / tan(*x * a);
    d = (float)1.;
L16:
    e = c * c / a;
    c *= d;
    a = aa[i - 1];
    d = (e + bb[i - 1]) / (e + a);
    --i;
    if (i != 0) {
	goto L16;
    }
    elp1_1.sn = 1 / sqrt(c * c + 1);
    elp1_1.cn = elp1_1.sn * c;
    elp1_1.dn = d;
    return 0;
L20:
    elp1_1.sn = (float)0.;
    elp1_1.cn = (float)1.;
    elp1_1.dn = (float)1.;
    return 0;
} /* elp_ */

/* ---------------ARC ELLIPTIC TANGENT--------------- */
doublereal arcsc_(u, kc)
real *u, *kc;
{
    /* System generated locals */
    real ret_val, r__1;

    /* Builtin functions */
    double sqrt();
    double atan();

    /* Local variables */
    static real a, b;
    static integer j, l;
    static real y, bt;

    a = (float)1.;
    b = *kc;
    y = (float)1. / *u;
    l = 0;
    for (j = 1; j <= 15; ++j) {
	bt = a * b;
	a += b;
	b = sqrt(bt) * (float)2.;
	y -= bt / y;
	if (y == (float)0.) {
	    y = sqrt(bt) * (float)1e-10;
	}
	if ((r__1 = a - b, fabs(r__1)) < a * (float)1.2e-7) {
	    goto L15;
	}
	l <<= 1;
	if (y < (float)0.) {
	    ++l;
	}
/* L10: */
    }
    printf("\nARCSC FAILED TO CONVERGE\n");
L15:
    if (y < (float)0.) {
	++l;
    }
    ret_val = (atan(a / y) + l * (float)3.141592654) / a;
    return ret_val;
} /* arcsc_ */

/* --------------MODULUS FROM RATIO OF K/K'--------------- */
doublereal fk_(u)
real *u;
{
    /* System generated locals */
    real ret_val, r__1;

    /* Builtin functions */
    double exp();
    double sqrt();

    /* Local variables */
    static real a, b, c, d;
    static integer j;
    static real q;

    q = exp(*u * (float)-3.141592654);
    a = (float)1.;
    b = (float)1.;
    c = (float)1.;
    d = q;
    for (j = 1; j <= 15; ++j) {
	a += c * 2 * d;
	c = c * d * d;
	b += c;
	d *= q;
	if (c < (float)1e-7) {
	    goto L15;
	}
/* L10: */
    }
    printf("\nFK FAILED TO CONVERGE\n");
L15:
/* Computing 2nd power */
    r__1 = b / a;
    ret_val = sqrt(q) * 4 * (r__1 * r__1);
    return ret_val;
} /* fk_ */

/* ----------------PRINT--------------------------------- */
/* Subroutine */ int prnt_(n2, pr, pi, zr, zi)
integer *n2;
real *pr, *pi, *zr, *zi;
{
    /* Format strings */
 /*   static char fmt_10[] = "(i3,4f14.6)"; */

    /* System generated locals */
    integer i__1;

    /* Builtin functions */

    /* Local variables */
    static integer i;

    /* Parameter adjustments */
    --zi;
    --zr;
    --pi;
    --pr;

    /* Function Body */
    printf("\n #,    ZEROS (REAL, IMAG),           POLES (REAL, IMAG)\n");
    i__1 = *n2 + 1;
    for (i = 1; i <= i__1; ++i) {
	printf("%3d ",i );
	printf("%f ",zr[i] );
	printf("%f   ",zi[i] );
	printf("%f ", pr[i] );
	printf("%f\n", pi[i] );
/* L1: */
    }
    return 0;
} /* prnt_ */

/* -----------CASCADE STRUCTURE PARRAMETERS-------------- */
/* Subroutine */ int cascad_(pr, pi, zr, zi, b1, b2, a1, a2)
real *pr, *pi, *zr, *zi, *b1, *b2, *a1, *a2;
{
    /* Format strings */
 /*   static char fmt_30[] = "(\002     \002,i3,2f12.6,\002  \002,2f12.6)"; */

    /* System generated locals */
    integer i__1;

    /* Builtin functions */

    /* Local variables */
    static integer j, k, j0;

  FILE  * output;


    /* Parameter adjustments */
    --a2;
    --a1;
    --b2;
    --b1;
    --zi;
    --zr;
    --pi;
    --pr;

    output= fopen("fx.dat","w");


    /* Function Body */
    printf("%d ", parm_1.n2 );
    fprintf(output,"%d\n", parm_1.n2 );
    printf("CASCADE STAGES, EACH OF THE FORM:\n" );
    printf("F(z) = (z*z  +  B1 z  +  B2)/(z*z  +  A1 z  +  A2)\n" );
    k = 0;
    if (parm_1.n2 % 2 != 0 && parm_1.kf == 3) {
	k = 1;
    }
    j0 = 1;
    if (parm_1.kod == 0) {
	goto L10;
    }
    b1[1] = (float)1.;
    if (parm_1.kf == 2) {
	b1[1] = (float)-1.;
    }
    b2[1] = (float)0.;
    a1[1] = -(doublereal)pr[1];
    a2[1] = (float)0.;
    printf("%d ",j0 );
    printf("%f %f %f %f\n", b1[j0], b2[j0], a1[j0], a2[j0] );
    fprintf(output,"%f %f %f %f\n", -a1[j0], -a2[j0], b1[j0], b2[j0] );
    j0 = 2;
L10:
    i__1 = parm_1.n2;
    for (j = j0; j <= i__1; ++j) {
	b1[j] = zr[j] * (float)-2.;
	b2[j] = zr[j] * zr[j] + zi[j] * zi[j];
	if (j == 1 && k == 1) {
	    b1[j] = (float)0.;
	}
	if (j == 1 && k == 1) {
	    b2[j] = (float)-1.;
	}
	a1[j] = pr[j] * (float)-2.;
	a2[j] = pr[j] * pr[j] + pi[j] * pi[j];
	if (pi[j] == (float)0.) {
	    a1[1] = -(doublereal)pr[1] - pr[parm_1.n2 + 1];
	}
	if (pi[j] == (float)0.) {
	    a2[1] = pr[1] * pr[parm_1.n2 + 1];
	}
	printf("%d %f %f %f %f\n", j, b1[j], b2[j], a1[j], a2[j] );
    fprintf(output,"%f %f %f %f\n", -a1[j], -a2[j], b1[j], b2[j] );

/* L15: */
    }
    fclose( output );
    return 0;
} /* cascad_ */

/* -------------ANALOG FILTER FREQ RESPONSE--------------------- */
/* Subroutine */ int afr_()
{
    /* Builtin functions */


    printf("ANALOG PART NOT FINISHED\n");
    return 0;
} /* afr_ */

/* -------------DIGITAL FILTER FREQ RESPONSE-------------------- */
/* Subroutine */ int dfr_(kk, b1, b2, a1, a2, fm)
integer *kk;
real *b1, *b2, *a1, *a2, *fm;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */

    /* Local variables */
    static integer i, j;
    static real q, w;
    static integer i0;
    static real w2, ai, bi, br, ar, bit, ait, ars, art, brt, brs;

    /* Parameter adjustments */
    --fm;
    --a2;
    --a1;
    --b2;
    --b1;

    /* Function Body */
    q = (float)3.141592654 / *kk;
    i__1 = *kk + 1;
    for (j = 1; j <= i__1; ++j) {
	w = q * (j - 1);
	w2 = w * (float)2.;
	br = (float)1.;
	bi = (float)0.;
	ar = (float)1.;
	ai = (float)0.;
	i0 = 1;
	if (parm_1.kod == 0) {
	    goto L10;
	}
	br = cos(w) + b1[1];
	bi = sin(w);
	ar = cos(w) + a1[1];
	ai = sin(w);
	i0 = 2;
L10:
	i__2 = parm_1.n2;
	for (i = i0; i <= i__2; ++i) {
	    brt = cos(w2) + b1[i] * cos(w) + b2[i];
	    bit = sin(w2) + b1[i] * sin(w);
	    art = cos(w2) + a1[i] * cos(w) + a2[i];
	    ait = sin(w2) + a1[i] * sin(w);
	    brs = br * brt - bi * bit;
	    bi = br * bit + bi * brt;
	    br = brs;
	    ars = ar * art - ai * ait;
	    ai = ar * ait + ai * art;
	    ar = ars;
/* L15: */
	}
	fm[j] = sqrt((br * br + bi * bi) / (ar * ar + ai * ai));
/* L20: */
    }
    return 0;
} /* dfr_ */

/* -----------OUTPUT FREQUENCY RESPONSE------------------ */
/* Subroutine */ int view_(kk, fm)
integer *kk;
real *fm;
{
    /* Format strings */
/*    static char fmt_100[] = "(10x,f15.8,e15.8)"; */

    /* System generated locals */
    integer i__1;

    /* Builtin functions */

    /* Local variables */
    static real f;
    static integer j;
    static real f0;

FILE *output;    
float highest= 0;

    
    /* Parameter adjustments */
    --fm;



    /* Function Body */
    output= fopen("fm.dat","w");

    f0 = (float).5 / *kk;
    i__1 = *kk + 1;
    for (j = 1; j <= i__1; ++j) {
	f = f0 * (j - 1);
	fprintf(output,"%f %f\n", f, fm[j] );
	if( fm[j] > highest ) highest= fm[j];
/* L10: */
    }
    fclose( output );
    output= fopen("fx.dat","a");
    fprintf(output,"%f\n",highest );
    fclose( output );

    return 0;
} /* view_ */

