/* this program discribes a filters response */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int filter_id();
double filter( double sample );
void set_defaults();
void alter();
void printem();
void mod( int freq, int sample );
void getk(int def);

/* global filter constants */

#define N 128
double a[N];



int filter_id(){    /* output a line describing this filter */
static int first_time= 0;
extern int order;

  printf("\n\n     *** 0 - 128 k FIR filter design ***\n");  
  if( first_time == 0 ){
     set_defaults();
     first_time= 1;
     }
  
  printf("\n       ( current filter order is %d )\n",order);
  return order;     /* symetrical filter */
}


double filter( double sample ){  /* simulate fir filter operation */

static double w[N];
double val;
int k;
extern int order;


 val= 0;
 k= order;
 w[0]= sample;
 while( --k ){
    val+=  a[k]*w[k];
    w[k]= w[k-1];
    }
 val+= a[0]*w[0];


 return val;

}

void set_defaults(){  /* load the default constants */
  getk( 1 );  /* load fx.dat */

}


void mod( int freq, int sample ){
double update, phase;
int i,j,k;
extern int order;

 if( freq ){
    update= (double)sample/(double)freq;   /* # of samples in 360 deg */
    update= 6.2831852/update;               /* update in radians */
    phase= 0; 

/* try starting in the middle so we keep the linear phase characteristic */
/* preset the phase so can go from start to finish */    

    j= order/2;
    k= 2*j;
    if( k == order ) {         /* even order */
       phase+= update/2.0;   /* split the diff */
       }
    while( --j >= 0 ) phase-= update;   /* find starting phase */

    for( i= 0; i < order; ++i ){
       a[i]= cos( phase ) * a[i] * 2;   /* mod constants to new freq */
       phase += update;
       }
    }
}


void alter(){  /* allow altering the filter constants */
char temp[80];
double val;
int k;

 printf("\n FIR filter\n");

 /* change the a[k] */
 for ( k= 0; k < N; k++ ){
   printf(" a[%d] is %lf ? ",k,a[k]);
   val= atof( gets(temp));
   a[k]= val ? val : a[k];
   if( temp[0] == '0' && val == 0 ) a[k]= 0;
 /*  a[N-k-1]= a[k]; */
   }


}


void printem(){     /* print out the constants */
FILE *fp;
int i;
extern order;

   printf("\n  Printing....");
   fp= fopen("consts.tmp","w");
   if( fp == 0 ) { 
      printf("\n Can't open file for some unknown reason");
      return;
      }

   fprintf(fp,"/* constants are reversed in memory for FIR filter */\n");
   fprintf(fp,"int consts[%d] =  {\n",order);
   for( i= order-1; i >= 0; --i ){
      fprintf(fp,"   %lfq15",a[i]);
      if( i != 0 ) fprintf(fp,",\n");
      }
   fprintf(fp,"\n      }; ");

   fclose( fp );
}


void getk(int def){    /* get constants from a file */
/* assume file is such as output from fr program */
FILE *fp;
char temp[80];
int i;
extern int order;

   if( def ) strcpy( temp,"fx.dat" );
   else{
      printf("\n Enter file name ");
      gets( temp );
      }
   if( ( fp= fopen(temp,"r") ) == 0 ){
      printf("\n Can't open %s...",temp);
      getch();
      return;
      }

   for( i= 0; i < N; ++i ){
    /*  if( feof( fp ) ) break;     /* use temp problems with cr/lf pair */
      if( fgets(temp,80,fp) == 0 ) break;
      sscanf(temp,"%lf",&a[i]);
      }

   order= i;
   /* zero any left over */
   for( ; i < N; ++i ) a[i]= (double) 0;

   fclose( fp );

}

