
/*  
   FIR.C    - filter response -  an attempt to simulate a  DSP fir filter 
*/

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <graphics.h>
#include <conio.h>
#include <string.h>
#include <math.h>


/* functions that are in filter.c */

extern int filter_id();
extern double filter( double sample );
extern void set_defaults();
extern void alter();
extern void printem();
extern mod( int freq, int sample_rate );  /* convert low pass to band pass */
extern getk(int def);

extern double a[];   /* the filter constants */

/* local function proto's */
void sweep();
int confirm( char *p );
void gen();
double response( double freq, int sample_rate);
double find_score();
int done();
void modulate();
double calc_response( int freq, int sample_rate );
void modtohigh();

#define SWEEP 1
#define ALTER 2
#define MODH 6
#define AUTOGEN 4
#define PRINT 5
#define INPORT 3
#define MOD 7

int order;

main(){

int command;
int color;

  color= readattr();
  while( 1 ){
     clrscrn2(color);
     order= filter_id();     /* display filter currently linked */
     printf("\n Enter number of desired function\n");
     printf("\n    1 - a sweep of freqencies");
     printf("\n    2 - alter the filter characteristics");
     printf("\n    3 - inport constants from a file");
     printf("\n    4 - generate FIR filter constants");
     printf("\n    5 - print filter constants to file ( consts.tmp )");
     printf("\n    6 - modulate low pass constants to highpass");
     printf("\n    7 - modulate low pass constants to bandpass");
     printf("\n\n -->         ");
     poscurs( cursrow(), 6 ); 
     command= getch() - '0';
     switch ( command ){
        case SWEEP:       sweep(); break;
        case ALTER:       alter();  break;
        case INPORT:      getk(0);   break;
        case AUTOGEN:     gen();   break;
        case PRINT:       printem(); break;
        case MODH:        modtohigh(); break;
        case MOD:         modulate();  break;
        default:          if( command < 0 ){ 
                             if(confirm("program exit")){
                                exit(0);  /* escape or return */
                                }
                             }
                          break;
        }
     }
}

void modtohigh(){  
int i;

  for( i= 1; i < order; i+= 2 ) a[i]= -a[i];  /* pretty simple heh? */

}
void modulate(){
int sample, freq;

   printf("\n Enter the center frequency ");
   scanf("%d%*c",&freq);
   printf("\n Enter the sample rate ");
   scanf("%d%*c",&sample);
   mod( freq, sample );
}

void sweep(){    /* sweep of freqs across a given range */

int low,mid,high;    /* band of freq */
int x;
int rate;        /* dsp sample freq */
char temp[80];
double scale=5.0;         

double  max_value;
int step;
double phase= 0;

  printf("\n What is the DSP sample frequency(9600)  ");
  rate= atoi( gets( temp ));
  rate= rate ? rate: 9600;
  printf("\n Enter lowest frequency in sweep(50)  ");
  low= atoi( gets( temp ));
  low= low ? low: 50;
  printf("\n Enter highest frequency in sweep(%d)  ",rate/2);
  high= atoi( gets( temp ));
  high= high ? high: rate/2;

  if( setvmode(18) != 18 ){     /* use VGA 640 x 400 16 colors */
     setvmode( DEFAULTMODE );
     printf("\n NEED a VGA card to run this program");
     exit(1);
     }

  sprintf(temp,"Sweep of filter response from %d Hz to %d Hz",low,high);
  move_to( 320 - 4 * strlen( temp ) , 8 );
  plots(temp);

  /* calculate step size */
  step= ( high - low )/ 250;

  /* print a log scale on side */
  for( x= 20; x >= -60 ; x-= 20 ){
     move_to( 0, 150 - (int)scale*x );
     sprintf(temp,"%+ddb",x);
     plots(temp);
     }
/* do this twice, 1st for calculated response and 2nd for simulation */  

  x= 35;
  for(mid= low ; mid < high ; mid += 2 * step ){
     if( ((x-35) % 100 ) == 0){
        move_to( x, 162 );
        plots("|");
        sprintf(temp,"%d",mid);
        move_to( x-8, 176 );
        plots(temp);
        }

     max_value= calc_response( mid, rate );

     if( max_value > 0 ){
        setpixel( x, 150 );
        pen_color(10);
        setpixel( x++, (int)(150 - scale*20*log10(max_value)) ); 
        setpixel( x, (int)(150 - scale*20*log10(max_value)) );
        pen_color(15);
        setpixel( x++, 150 );
        x+= 2;
        }
     else x+= 4;
     if( kbhit() ) break; 
     }

  if( kbhit() ) getch();

  x= 35;
  for(mid= low ; mid < high ; mid += step ){
     if( ((x-35) % 100 ) == 0){
        move_to( x, 162 );
        plots("|");
        sprintf(temp,"%d",mid);
        move_to( x-8, 176 );
        plots(temp);
        }

     max_value= response( mid, rate );

     if( max_value > 0 ){
        setpixel( x, 150 );
        pen_color(14);
        setpixel( x++, (int)(150 - scale*20*log10(max_value)) ); 
        setpixel( x, (int)(150 - scale*20*log10(max_value)) );
        pen_color(15);
        setpixel( x++, 150 );

        }
     else x+= 2;

     if( kbhit() ) break;
     }


  /* at end of graphics presentation */
  move_to( 250, 440 );
  plots("Hit a key to cont...");
  getch();  /* pause */
  setvmode( DEFAULTMODE );
}

int confirm( char *p ){
int c;

   printf("\n    TYPE 'y' to confirm %s",p);
   c= getch();
   if( c == 'y' || c == 'Y' ) return 1;
   return 0;
}


struct freq{
   double val;        /* freq value */
   double highval;    /* limits  in db*/
   double lowval;
   double lastval;    /* where it was db */
   double thisval;    /* current trial value */
   };


void gen(){         /* generate filter constants based upon user spec's */
char temp[6];


   printf("\n\n");
   printf("Enter a number for desired generation method\n");
   printf("  1 - Band pass using freq sampling\n");
   printf("  3 - Low pass, least square, with transition region\n");
   printf("  4 - Low pass with selection of window functions\n");
   printf("Selection...");

   temp[0]= 'p';
   temp[1]= getch();
   temp[2]= 0;
   printf("\n\n");

   system(temp);  /* call external generation program */
   getk(1);      /* load the new constants */


}


int done( struct freq *freqs ){  /* determine if done */

int i;

  for( i= 0; i < 20; i++){
    if( freqs->val == 0 ) return 1;   /* all check ok */
    if( freqs->lastval > freqs->highval ) return 0;
    if( freqs->lastval < freqs->lowval ) return 0;
    freqs += 1;  /* advance by sizeof stucture */
    }
  return 1;  

}


/* evaluate this freq */
double find_score( struct freq *freq1 ){  

  /* two cases, lastval is too high or too low */
  if( freq1->lastval > freq1->highval )
              return( freq1->lastval - freq1->thisval );  /* going down is good */

  /* may be too low or moved in range */
  if( freq1->lastval < freq1->lowval )
              return( freq1->thisval - freq1->lastval );  /* going up is good */

  return (double)0;
}

  /* calculate the filter response */
double response( double freq, int sample_rate ){

double spu;
double max_value, sample; 
static double phase, old_freq;
int i;


     spu= 6.2832 * freq / sample_rate;  /* compute signal phase update in radians */
  /* avoid discontinuity in freqs sent to filter */
     max_value= freq - old_freq;
     if( max_value < 0 ) max_value= -max_value;
     if( max_value > 50 ){
        for( i= 0; i < 50; i++){  
           filter( sin(phase));
           phase += spu;
           }
        }
     old_freq= freq;
     max_value= 0;
     for( i= 0; i < (long)(sample_rate/freq) + 30 ; i++){
        sample= filter(sin(phase)); 
        if( sample > max_value ) max_value= sample;
        phase+= spu;
        }
    return max_value;
}



double calc_response( int freq, int sample ){
double q,at,am,v,as;
int i;

/*  q= 3.1415926 * freq /sample; */
  q= 6.2832 * freq / sample; /* compute signal phase update in radians */
  am= ((double)order) * 0.5;
  as= at= 0;
  for( i= 0; i < order; ++i ){
     v= (q*(am-(double)i));
     at= at + a[i]*cos(v);
   /*  as= as + a[i]*sin(v); */
     }
     
  if( at < 0 ) at= -at;
  if( as < 0 ) as= -as;

/* return( as > at ? as : at ); */
return at;
}
/*

void FREQ( double X[], double A[], int N, int K ){
double Q, AM, AT;
int M, N2, J, I;
                  * wrong value for pi( its 5926... )
        Q = 3.141582654/K;
        AM = (N+1)*0.5;
        M  = (N+1)/2;
        N2 = N/2;
        for( J= 1; J <= K+1; ++J ){
           AT = 0;
           if (AM == M) AT = 0.5*X[M];
           for( I= 1; I <= N2; ++I ){
              AT = AT + X[I]*cos(Q*(AM-I)*(J-1));
              }
           A[J] = 2*AT;
           }
}
*/

