/* calc # of coefficients for an optimal FIR filter  */
/* from book Digital Signal Processing, Ifeature, Jervis */


#include <stdio.h>
#include <math.h>
#include <conio.h>


int filter_spec();
double lpfcoeff();
double bpfcoeff();

float dp,ds,df;
int ftype;

main(){
  
double N;

   ftype= filter_spec();
   switch( ftype ){
      case 1:  N= lpfcoeff(); break;
      case 2:  N= bpfcoeff(); break;
      default:
      printf("Illegal filter type selected\n");
      break;
      }
   
   printf("Number of coefficients     \t%f\n",N);
   printf("Passband ripple in dB      \t%f\n",dp);
   printf("Stopband attenuation in dB \t%f\n",ds);
   printf("\nPress enter to continue...");
   getch();
}   


int filter_spec(){
int itype;

   printf("Program to estimate Optimal filter length\n");
   printf("\nSelect filter type\n");
   printf("1   for optimal LOWPASS filter\n");
   printf("2   for optimal BANDPASS filter\n");
   scanf("%d",&itype);
   printf("\nEnter passband and stopband deviations in ordinary units\n");
   printf("deviations must be between 0 and 1\n");
   scanf("%f%f",&dp,&ds);
   switch(itype){
      case 1:
      printf("Enter normalized transistion width \n");
      scanf("%f",&df);
      break;

      case 2:
      printf("Enter normalized transistion width ( smallest )\n");
      scanf("%f",&df);
      break;
      }
   return itype;
}


double lpfcoeff(){
float ddp, dds, a1, a2, a3, a4, a5, a6, b1, b2;
double dinf,ff,t1,t2,t3,t4,NI;

  a1= 0.005309;   a2= 0.07114;
  a3= -0.4761;    a4= -0.00266;
  a5= -0.5941;    a6= -0.4278;
  b1= 11.01217;   b2= 0.5124401;

  ddp= log10(dp);
  dds= log10(ds);
  t1= a1*ddp*ddp;
  t2= a2*ddp;
  t3= a4*ddp*ddp;
  t4= a5*ddp;
  dinf= ((t1+t2+a3)*dds)+(t3+t4+a6);
  ff= b1+b2*(ddp-dds);
  NI= ((dinf/df)-(ff*df)+1);
  dp= 20*log10(1+dp);
  ds= -20*log10(ds);
  return NI;
}

double bpfcoeff(){
float a1,a2,a3,a4,a5,a6,ddp,dds;
double t1,t2,t3,t4,cinf,ginf,Nb;

   a1=0.01201;     a2= 0.09664;
   a3= -0.51325;   a4= 0.00203;
   a5= -.57054;    a6= -0.44314;

  ddp= log10(dp);
  dds= log10(ds);
  t1= a1*ddp*ddp;
  t2= a2*ddp;
  t3= a4*ddp*ddp;
  t4= a5*ddp;
  cinf= dds*(t1+t2+a3)+t3+t4+a6;
  ginf= -14.6*log10(dp/ds)-16.9;
  Nb= (cinf/df)+ginf*df+1;
  dp= 20*log10(1+dp);
  ds= -20*log10(ds);
  return Nb;
}

