/*
C       FREQUENCY SAMPLING OR INTERPOLATION FOR FIR FILTERS
C       TRUNCATION YIELDS OPTIMAL LEAST-SQUARES DESIGN
C       DESIGN PROGRAM FOR A LINEAR PHASE LOWPASS FILTER
C         FILTER LENGTH AND NO. OF FREQ SAMPLES = N
C         BANDEDGE IN HZ = FP,  FOR SAMPLING RATE = 1
C         FREQ. SAMPLE AT DC: DC = 0
C         NO FREQ. SAMPLE AT DC: DC = 1
C         FREQUENCY RESPONSE CALCULATED AT K POINTS
C       C.S. BURRUS,   RICE UNIVERSITY,  JAN 1986
 modified for bandpass design
 removed non dc sample code and response calculation
 added one sample in transistion bands at @0.4 per table in book
 to improve stopband response
C---------------------------------------------------------
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

double X[130], A[130];
double AM,Q;
int M,N,N2,M1,J,I;
double F,FP,FP1;
double XT, NP;
double sample,center,bandwidth;


main(){
FILE *fpo; 
 
 printf("FREQUENCY SAMPLING DESIGN OF A BANDPASS FILTER\n");
 printf("( with one transition sample )\n");
 printf("Enter filter order ");
 scanf("%d",&N);
 printf("Enter sampling frequency ");
 scanf("%lf",&sample);
 printf("Enter center frequency ");
 scanf("%lf",&center);
 printf("Enter desired bandwidth ");
 scanf("%lf",&bandwidth);
 printf("\nGenerating constants...");

  FP1= ( center - 0.5*bandwidth ) / sample; /* convert to unity sample */
  FP= (center + 0.5*bandwidth ) /sample;
  if( FP1 < 0 ) FP1= 0;

 /* scanf("%d %lf %lf",&N, &FP1, &FP); */

        M  = (N+1)/2 ;
        AM = (N+1.0)/2.0 ;
        M1  = N/2 + 1 ;
        Q  = 6.2831853079586/N ;
        N2  =  N/2 ;
        NP = N*FP + 1.0;  /*(( DC == 0 ) ? 1.0 : 0.5) ;*/
/* C------------SET DESIRED FREQ RESPONSE-------------------- */
        for( J= 1; J <= NP; ++J ) A[J] = 1.0 ;
        for( J= NP+1; J <= M1; ++J ) A[J]= 0.0;
       A[(int)(NP+1)]= 0.43;  /* modified for transition */
        NP= N * FP1 + 1.0;
        for( J= 1; J <= NP; ++J ) A[J]= 0.0; /* band stop */
       A[(int)NP]= 0.43;
        if( A[J] < 1.0 ){
           printf("\nThe Filter Order is too small");
           printf("\nContinuing, but bandwidth will be wider than wanted...");
           A[J]= 1.0;
           }
/* C------------TYPE 1&2, DC FREQ SAMPLE--------------------- */
           for( J= 1; J <= M; ++J ){
              XT = A[1]/2.0;
              for( I= 2; I <= M; ++I ){
                 XT = XT + A[I]*cos(Q*(AM-J)*(I-1));
                 }
              X[J] = 2.0*XT/N;
              }
/* C--------------------OUTPUT------------------------------- */

        fpo= fopen("fx.dat","w");
        for( J= 1; J <= M; ++J ) fprintf(fpo,"%lf\n",X[J]);
        for( J= N/2; J > 0; --J) fprintf(fpo,"%lf\n",X[J]);
        fclose( fpo );

} /* C-------------------END OF MAIN PROGRAM--------------------- */

