
/*
C       LEAST SQUARE ERROR FIR FILTERS WITH A TRANSITION REGION
C       DESIGN PROGRAM FOR A LINEAR PHASE LOWPASS FILTER
C       FILTER LENGTH = N
C         PASSBAND EDGE IN HERTZ = FP
C         STOPBAND EDGE IN HERTZ = FS,  FOR SAMPLING RATE = 1
C       TRANSITION TYPE = TP: 0. RAISED COSINE. 1. LINEAR, 2. 2ND ORDER,
C               3. 3RD ORDER, 4. 4TH ORDER, ETC.;   FP=FS=NO TRANSITION
C         FREQUENCY RESPONSE CALCULATED AT K POINTS
C       C.S. BURRUS,  RICE UNIVERSITY,  JAN 1986
C---------------------------------------------------------
*/

#include <stdio.h>
#include <math.h>


void ls( double x[], int n, double fr, double fq );
void wgt( double x[], int n, int tp, double fr, double fq );
void freq( double x[], double b[], int n, int k );


main(){

int tp;
double x[101], b[1001];
double fs,fp,fq,fr,f;
int j,m,n;
int k;
FILE *fpo;
   
   printf("\nLinear Phase FIR  Low Pass Filter");
   printf("\nLeast square design with a transition region");
   printf("\nEnter filter order ");
   scanf("%d",&n);
   printf("\nEnter freq's as fractions of sample rate of 1");
   printf("\nEnter pass band cut off ");
   scanf("%lf",&fp);
   printf("\nEnter stop band cut off ");
   scanf("%lf",&fs);
   printf("\nTransition type is zero for raised cosine, and N for n order spline");
   printf("\nEnter transition type ");
   scanf("%d",&tp);
/*   printf("\nEnter number of samples for freq response calculation ");
   scanf("%d",&k);
*/

   m= (n+1) / 2;
   fq= fs - fp;
   fr= fs + fp;

/* C--------------------DESIGN------------------------------ */
   ls( x, n, fr, fq );
   wgt( x, n, tp, fr, fq );

/* C--------------------OUTPUT------------------------------ */
   fpo= fopen("fx.dat","w");
   for( j= 1; j <= m; ++j ) fprintf(fpo,"%lf\n",x[j]);
   for( j= n/2; j > 0; --j) fprintf(fpo,"%lf\n",x[j]);
   fclose( fpo );
 /*  freq( x, b, n, k ); */
 /*  fpo= fopen("fm.dat","w");
   for( j= 1; j <= ( k + 1); ++j ){
      f= 0.5 * ( j - 1 ) / (double)k;
      fprintf(fpo,"%lf   %lf\n",f,( b[j] < 0)  ? -b[j] : b[j]);
      }   
 */
} 
/* C---------------END OF MAIN PROGRAM-------------------- */


void ls( double x[], int n, double fp, double fq ){
double p, q, am;
int j, m, n2;

   p= 3.141592654;
   m= (n+1)/2;
   am= ((double)n+1.0)/2.0;
   n2= n/2;
   if( m == am ) x[m]= fp;

   for( j= 1; j <= n2; ++j ){
      q= p*((double)j-am);
      x[j]= (sin(fp*q))/q;
      }
}


/* C------------------WEIGHTS----------------------- */
void wgt( double x[], int n, int tp, double fp, double fq ){

double  q1, wt, p, am, q;
int j;

   am= ((double)n+1.0)/2.0;
   p= 3.141592654;
   q= p*fq;
   if( fq == 0 ) return;
   if( tp != 0 ){
/* C---------------TP ORDER SPLINE--------------- */
      for( j= 1; j < am; ++j ){
         q1= q*((double)j-am)/(double)tp;
         wt= pow( sin(q1)/q1, (double)tp );
         x[j]*= wt;
         }
      }
   else{
 
/* C--------------RAISED COSINE--------------------- */
      for( j= 1; j < am; ++j ){
         q1= q*((double)j-am);
         wt= fq*( (double)j - am );
         wt*= wt;
         wt= sin(q1)/(q1*(1-wt));
         x[j]*= wt;
         }
      }
} 


/* C--------------FREQUENCY RESPONSE------------- */


void freq( double x[], double a[], int n, int k ){
double q, am, at;
int j, n2, m, i;

   q= 3.141592654/(double)k;
   am= ((double)n+1)*0.5;
   m= (n+1)/2;
   n2= n/2;
   for( j= 1; j <= ( k + 1 ); ++j ){
      at= 0;
      if( am == m ) at= 0.5 * x[m];
      for( i= 1; i <= n2; ++i ){
         at= at + x[i]*cos(q*(am-i)*(j-1));
         }
      a[j]= 2*at;
      }
}
