/* p4.f -- translated by f2c (version 19940714).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "f2c.h"
#include <stdio.h>
#include <math.h>

/* Table of constant values */

static integer c__3 = 3;
static integer c__1 = 1;
static integer c__4 = 4;
static integer c__9 = 9;
/*       LEAST SQUARE ERROR AND WINDOWS FOR FIR FILTERS */
/*       DESIGN PROGRAM FOR A LINEAR PHASE LOWPASS FILTER */
/*         FILTER LENGTH = N */
/*         BAND EDGE IN HERTZ = FP,    FOR SAMPLING RATE = 1 */
/*         WINDOW TYPE:     TP =  0.RECTANGULAR, 1.BARTLETT, */
/*                2.HANNING, 3.HAMMING, 4.BLACKMAN, 5.KAISER */
/*         KAISER WINDOW PARAMETER = BETA */
/*         FREQUENCY RESPONSE CALCULATED AT K POINTS */
/*       C.S. BURRUS,   JAN 1986 */
/* --------------------------------------------------------- */
/* Main program */ 
main(){

   FILE *output;

    /* System generated locals */
    integer i__1;
    real r__1, r__2;

    /* Local variables */
    extern /* Subroutine */ int freq_(), wind_();
    static real b[1001], f;
    static integer j, k, m, n;
    static real x[101], fp;
    extern /* Subroutine */ int ls_();
    static integer tp;


/* --------------------INPUT SPECIFICATIONS----------------- */
    
    printf("LEAST SQUARE DESIGN WITH WINDOWS\n\n");
    printf("Enter filter order ");
    scanf("%d",&n);
    printf("\nEnter frequencies as fractions of unit sample rate");
    printf("\nEnter pass band cut off ");
    scanf("%f",&fp);
    printf("\nEnter transistion window type... ");
    printf("\n  0 - rectangular\n  1 - Bartlett\n  2 - Hanning\n  3 - Hamming");
    printf("\n  4 - Blackman\n  5 - Kaiser\n      Choice... ");
    scanf("%d",&tp);
    k= 5;   /* no of samples for response */
    
    m = (n + 1) / 2;
/* --------------------DESIGN------------------------------ */
    ls_(x, &n, &fp);
    wind_(x, &n, &tp);
/* --------------------OUTPUT------------------------------ */
    output= fopen("fx.dat","w");
    i__1 = m;
    for (j = 1; j <= i__1; ++j) {
       fprintf(output,"%f\n",x[j-1]);
       }
    m= n /2;
    for ( j= m; j > 0; --j ){
       fprintf(output,"%f\n",x[j-1]);
       }
    fclose(output);

    freq_(x, b, &n, &k);
 /*   output= fopen("fm.dat","w");
    i__1 = k + 1;
    for (j = 1; j <= i__1; ++j) {
	f = (j - 1) * (float).5 / k;
	r__2 = ( b[j - 1] >= 0 ) ? b[j-1] : -b[j-1];  /* float abs() */
	
/*        fprintf(output,"%f   %f\n",f,r__2);
    }      skip response output       */

} /* MAIN__ */

/* ---------------END OF MAIN PROGRAM-------------------- */

/* Subroutine */ int ls_(x, n, fp)
real *x;
integer *n;
real *fp;
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
/*    double sin(); */

    /* Local variables */
    static integer j, m;
    static real p, q;
    static integer n2;
    static real am;


    /* Parameter adjustments */
    --x;

    /* Function Body */
    p = (float)3.141592654;
    m = (*n + 1) / 2;
    am = (*n + (float)1.) / (float)2.;
    n2 = *n / 2;
    if ((real) m == am) {
	x[m] = *fp * (float)2.;
    }
    i__1 = n2;
    for (j = 1; j <= i__1; ++j) {
	q = p * (j - am);
	x[j] = sin(*fp * 2 * q) / q;
/* L10: */
    }
    return 0;
} /* ls_ */

/* ------------------WINDOWS----------------------- */
/* Subroutine */ int wind_(x, n, tp)
real *x;
integer *n, *tp;
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
/*    double cos();
    integer s_wsle(), do_lio(), e_wsle(), s_rsle(), e_rsle();
    double sqrt();
*/
    /* Local variables */
    static integer j;
    static real q, q1, am, wt, arg, bet;
    extern doublereal fio_();
    static real fio1;
  

    /* Parameter adjustments */
    --x;

    /* Function Body */
    if (*tp == 0) {
	return 0;
    }
    am = (*n + (float)1.) / (float)2.;
    q = (float)3.141592654 / am;
    q1 = (float)3.141592654 / (am - 1);
    switch ((int)*tp) {
	case 1:  goto L1;
	case 2:  goto L2;
	case 3:  goto L3;
	case 4:  goto L4;
	case 5:  goto L5;
    }
    return 0;
/* ------------------BARTLETT---------------------- */
L1:
    i__1 = am;
    for (j = 1; j <= i__1; ++j) {
	wt = j / am;
	x[j] = wt * x[j];
/* L11: */
    }
    return 0;
/* -----------------HANNING------------------------ */
L2:
    i__1 = am;
    for (j = 1; j <= i__1; ++j) {
	wt = (float).5 - cos(j * q) * (float).5;
	x[j] = wt * x[j];
/* L12: */
    }
    return 0;
/* -----------------HAMMING------------------------ */
L3:
    i__1 = am;
    for (j = 1; j <= i__1; ++j) {
	wt = (float).54 - cos((j - 1) * q1) * (float).46;
	x[j] = wt * x[j];
/* L13: */
    }
    return 0;
/* -----------------BLACKMAN------------------------ */
L4:
    i__1 = am;
    for (j = 1; j <= i__1; ++j) {
	wt = (float).42 - cos(j * q) * (float).5 + cos((j << 1) * q) * (float)
		.08;
	x[j] = wt * x[j];
/* L14: */
    }
    return 0;
/* -----------------KAISER------------------------ */
L5:
    
    printf("\nValue of beta will depend on desired stopband attenuation requirements");
    printf("\nvalues from 0 to 9 will produce stopbands of -20 to -90 db");
    printf("\nEnter value for BETA ");
    scanf("%f",&bet);
    fio1 = fio_(&bet);
    i__1 = am;
    for (j = 1; j <= i__1; ++j) {
/* Computing 2nd power */
	r__1 = (am - j) / (am - 1);
	arg = bet * sqrt(1 - r__1 * r__1);
	wt = fio_(&arg) / fio1;
	x[j] = wt * x[j];
/* L15: */
    }
    return 0;
} /* wind_ */

/* ----------------IO FUNCTION-------------------- */
doublereal fio_(z)
real *z;
{
    /* System generated locals */
    real ret_val;

    /* Builtin functions */
/*    integer s_wsle(), do_lio(), e_wsle(); */

    /* Local variables */
    static real d, e;
    static integer j;
    static real y, d2;

    y = *z / (float)2.;
    e = (float)1.;
    d = (float)1.;
    for (j = 1; j <= 25; ++j) {
	d = d * y / j;
	d2 = d * d;
	e += d2;
	if (d2 < e * (float)1e-7) {
	    goto L15;
	}
/* L10: */
    }

    printf("\nIO FAILED TO CONVERGE");
    getch();

L15:
    ret_val = e;
    return ret_val;
} /* fio_ */

/* -------------------------------------------------- */
/* Subroutine */ int freq_(x, a, n, k)
real *x, *a;
integer *n, *k;
{
    /* System generated locals */
    integer i__1, i__2;

    /* Builtin functions */
/*    double cos(); */

    /* Local variables */
    static integer i, j, m;
    static real q;
    static integer n2;
    static real am, at;


    /* Parameter adjustments */
    --a;
    --x;

    /* Function Body */
    q = (float)3.141592654 / *k;
    am = (*n + 1) * (float).5;
    m = (*n + 1) / 2;
    n2 = *n / 2;
    i__1 = *k + 1;
    for (j = 1; j <= i__1; ++j) {
	at = (float)0.;
	if (am == (real) m) {
	    at = x[m] * (float).5;
	}
	i__2 = n2;
	for (i = 1; i <= i__2; ++i) {
	    at += x[i] * cos(q * (am - i) * (j - 1));
/* L10: */
	}
	a[j] = at * 2;
/* L20: */
    }
    return 0;
} /* freq_ */

